﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using System.Text.RegularExpressions;

namespace BMS.Web.Controllers.Shared
{
    [AttributeUsage(AttributeTargets.All, AllowMultiple=true)]
    public class NotContainsIfAttribute : ValidationAttribute
    {
        public string DependentProperty { get; set; }
        public string Pattern { get; set; }
        public object TargetValue { get; set; }

        public NotContainsIfAttribute(string pattern, string dependentProperty, object targetValue)
        {
            this.DependentProperty = dependentProperty;
            this.TargetValue = targetValue;
            this.Pattern = pattern;
        }

        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {

            // get a reference to the property this validation depends upon
            var containerType = validationContext.ObjectInstance.GetType();
            var field = containerType.GetProperty(this.DependentProperty);

            if (field != null)
            {
                // get the value of the dependent property
                var dependentvalue = field.GetValue(validationContext.ObjectInstance, null);

                // compare the value against the target value
                if ((dependentvalue == null && this.TargetValue == null) ||
                    (dependentvalue != null && dependentvalue.Equals(this.TargetValue)))
                {
                    // match => means we should try validating this field
                    string container = (string)value;
                    if (!string.IsNullOrEmpty(container) && Regex.IsMatch(container, Pattern))
                        // validation failed - return an error
                        return new ValidationResult(this.ErrorMessage, new[] { validationContext.MemberName });
                }
            }

            return ValidationResult.Success;
        }
    }
}